One of Bonnie's most useful features is its cross-platform abilities. A single Bonnie alias can run **different commands on different operating systems**. That means you can fearlessly share one configuration between multiple collaborators on different OSes with the confidence that everything will work for everyone!

```toml
version = "0.3.2"

[scripts]
test.generic = "echo Fallback"
test.targets.windows = "echo Windows"
test.targets.macos = "echo MacOS"
test.targets.linux = "echo Linux"
```

```
# On Windows
bonnie test	# Windows
# On MacOS
bonnie test	# MacOS
# On Linux
bonnie test	# Linux
# On anything else
bonnie test	# Fallback
```

You can specify different commands for different OSes under the `.targets` property. If `.targets` is present. you also need to define `.generic` as a fallback for if the command is run on an unrecognized system. If you're using `.cmd` syntax, `.generic` and `.target` must be nested under that. This means the arguments and environment variables you want to interpolate have to be defined universally, for all systems (but you don't have to use all of them everywhere). As usual, anywhere that a string command can be specified can also take an array for a multistage command (you can have different stage progressions on different OSes). Note that subcommands must be universal.

You can define as many or as few OSes as you want under `.targets`, and the property will accept any named OS. However, as of right now, the following operating systems are all that are supported. If you'd like more, please [open an issue](https://github.com/arctic-hen7/bonnie/issues/new/choose)!

- Windows `windows`
- MacOS `macos`
- Linux `linux`
- iOS `ios`
- Android `android`
- FreeBSD `freebsd`
- OpenBSD `openbsd`
- NetBSD `netbsd`
- Dragonfly `dragonfly`
